<?php
/* --------------------------------------------------------------
   FetchedAllWithdrawals.php 2020-03-30
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Events;

use Gambio\Admin\Withdrawal\Interfaces\Withdrawals;

/**
 * Class FetchedAllWithdrawals
 *
 * @package Gambio\Admin\Withdrawal\Events
 */
class FetchedAllWithdrawals
{
    /**
     * @var Withdrawals
     */
    private $withdrawals;
    
    
    /**
     * FetchedAllWithdrawalsEvent constructor.
     *
     * @param Withdrawals $withdrawals
     */
    private function __construct(Withdrawals $withdrawals)
    {
        $this->withdrawals = $withdrawals;
    }
    
    
    /**
     * @param Withdrawals $withdrawals
     *
     * @return FetchedAllWithdrawals
     */
    public static function create(Withdrawals $withdrawals): FetchedAllWithdrawals
    {
        return new self($withdrawals);
    }
    
    
    /**
     * @return Withdrawals
     */
    public function withdrawals(): Withdrawals
    {
        return $this->withdrawals;
    }
    
    
    /**
     * @param Withdrawals $withdrawals
     */
    public function replaceWithdrawals(Withdrawals $withdrawals): void
    {
        $this->withdrawals = $withdrawals;
    }
}